using System;
using System.Reflection;
using System.Collections.Generic;
using System.Text;

namespace ReflectMethods
{
   class Program
   {
      static void Main(string[] args)
      {
         Customer<string> cust = new Customer<string>();
         Type t = cust.GetType();
         MethodInfo method = t.GetMethod("DoSomething");
         Console.WriteLine(method.Name);
         Console.WriteLine("..........................");
         Console.Write("Abstrakcyjna: {0}, Widoczna dla Zestawu: {1}, Konstruktor: {2}, Domknita: {3}, ",
            method.IsAbstract ? "Prawda" : "Fasz", method.IsAssembly ? "Prawda" : "Fasz",
            method.IsConstructor ? "Prawda" : "Fasz", method.IsFinal ? "Prawda" : "Fasz");
         Console.WriteLine("Oglna: {0}, Wirtualna: {1}, Statyczna: {2}...",
            method.IsGenericMethod ? "Prawda" : "Fasz", method.IsVirtual ? "Prawda" : "Fasz",
            method.IsStatic ? "Prawda" : "Fasz");
         Console.WriteLine("{0} zwraca {1}...", method.Name, method.ReturnType.ToString());
         Console.WriteLine("Parametry:");
         foreach (ParameterInfo p in method.GetParameters())
         {
            Console.WriteLine("\t{0} : {1} [{2}]{3}",
               p.Name, p.ParameterType.ToString(),
               p.IsOut ? "Wyjciowy" : "Wejciowy",
               p.ParameterType.IsGenericParameter ? "* Oglny" : "");
         }
         Console.WriteLine("Zmienne lokalne w obrbie metody:");
         foreach (LocalVariableInfo lvi in method.GetMethodBody().LocalVariables)
         {
            Console.WriteLine(lvi.ToString());
         }

         Console.ReadLine();
      }
   }
}
